<?php
include_once('./_common.php');

$author = array();

$is_auth = false;
$is_aushop = false;
$is_myshop = false;
$is_partner = false;

$id = trim($id);

if($id) {
	$mb_id = $id;
	$author = apms_member($mb_id);
	if($mb_id == $config['cf_admin']) {
		$is_aushop = true;
	} else {
		if(!$author['partner']) {
			alert('등록된 마이샵이 없습니다.', G5_URL);
		}
	}
	$rss_href = G5_URL.'/rss/?id='.$id;
	$mode = ''; // id 값이 있으면 모드는 활성화시키지 않음.
} else {
	if($is_guest) {
		alert('회원만 이용가능합니다.', G5_URL);
	}

	if($member['mb_id'] == $config['cf_admin']) {
		$is_auth = true;
		$is_myshop = true;
	} else if(IS_PARTNER) {
		$is_myshop = true;
		$is_partner = true;
	} else {
		alert('파트너만 이용가능합니다.', G5_URL);
	}

	define('G5_IS_ADMIN', true);

	$author = $member;
	$mb_id = $member['mb_id'];
	$rss_href = '';

}

// 모드별 파일체크
switch($mode) {
	case 'dashboard'	: $skin_file = './myshop.dashboard.php'; break;
	case 'salelist'		: $skin_file = './myshop.salelist.php'; break;
	case 'saleitem'		: $skin_file = './myshop.saleitem.php'; break;
	case 'delivery'		: $skin_file = './myshop.delivery.php'; break;
	case 'sendcost'		: $skin_file = './myshop.sendcost.php'; break;
	case 'paylist'		: $skin_file = './myshop.paylist.php'; break;
	case 'list'			: $skin_file = './myshop.itemlist.php'; break;
	case 'item'			: $skin_file = './myshop.itemform.php'; break;
	case 'comment'		: $skin_file = './myshop.comment.php'; break;
	case 'qalist'		: $skin_file = './myshop.qalist.php'; break;
	case 'qaform'		: $skin_file = './myshop.qaform.php'; break;
	case 'uselist'		: $skin_file = './myshop.uselist.php'; break;
	default				: $skin_file = './myshop.index.php'; break;
}

// 파트너 버전 설치여부
$is_activate = (file_exists('./myshop.dashboard.php')) ? true : false;

if(file_exists($skin_file)) {
	// Page ID
	$pid = ($pid) ? $pid : 'myshop';
	$at = apms_page_thema($pid);
	if(!defined('THEMA_PATH')) {
		include_once(G5_LIB_PATH.'/apms.thema.lib.php');
	}

	list($skin_path, $skin_url) = apms_skin_path('head.skin.php', '/shop/myshop');

	include_once('./_head.php');
	include_once($skin_path.'/head.skin.php');
	include_once($skin_file);
	include_once($skin_path.'/tail.skin.php');
	include_once('./_tail.php'); 
} else {
	if($is_auth) {
		$msg = "본 기능은 APMS 파트너 버전에서만 사용할 수 있습니다.\\n\\n관리자화면으로 이동합니다.";
		switch($mode) {
			case 'salelist'	: $url = 'orderlist.php'; break;
			case 'delivery'	: $url = 'orderlist.php'; break;
			case 'list'		: $url = 'itemlist.php'; break;
			case 'item'		: $url = 'itemlist.php'; break;
			case 'qalist'	: $url = 'itemqalist.php'; break;
			case 'qaform'	: $url = 'itemqalist.php'; break;
			case 'uselist'	: $url = 'itemuselist.php'; break;
			default			: $url = ''; break;
		}
		alert($msg, G5_ADMIN_URL.'/shop_admin/'.$url);
	} else {
		$msg = "본 기능은 APMS 파트너 버전에서만 사용할 수 있습니다.";
		alert($msg, G5_SHOP_URL.'/myshop.php');
	}
}

?>
